using System;
using System.Xml;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents close socket request message as 
	/// defined in VistALink protocol specification.
	/// </summary>
    public sealed class VistALinkCloseSocketRequestMessage : VistALinkSimpleRequestMessage
	{
		/// <summary>
		/// VistALink message request type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string RequestType = "closeSocket"; 

		/// <summary>
		/// Constructor specifying minimal required VistALink 
		/// close socket request message parameters. 
		/// </summary>
		public VistALinkCloseSocketRequestMessage() 
			: base( RequestType ) 
		{			
			this.SetHandlerMode( HandlerMode.SingleCall ); 
		}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document</param>
		public VistALinkCloseSocketRequestMessage( XmlDocument sourceDoc )
			: base( RequestType, sourceDoc ) 
		{	
			if( this.HandlerMode != HandlerMode.SingleCall )
				throw( new XmlParseException( 
					SR.Exceptions.VistALinkCloseSocketRequestMsgIncorrectHandlerMode( 
						HandlerMode.SingleCall.ToString(), this.HandlerMode.ToString() ) ) );
		}
	}
}
